-- Add Financial Tables for Quran Teaching App
-- Migration: 008_AddFinancialTables

-- Teacher Salaries Table
CREATE TABLE IF NOT EXISTS TeacherSalaries (
    SalaryID INTEGER NOT NULL CONSTRAINT PK_TeacherSalaries PRIMARY KEY AUTOINCREMENT,
    TeacherID INTEGER NOT NULL,
    Amount DECIMAL(18,2) NOT NULL,
    Month INTEGER NOT NULL,
    Year INTEGER NOT NULL,
    PaymentDate TEXT NOT NULL,
    PaymentMethod TEXT DEFAULT 'نقدي',
    PaymentMethodArabic TEXT DEFAULT 'نقدي',
    ReceiptNumber TEXT DEFAULT '',
    Notes TEXT NULL,
    CreatedDate TEXT NOT NULL,
    CONSTRAINT FK_TeacherSalaries_Teachers FOREIGN KEY (TeacherID) REFERENCES Teachers (TeacherID) ON DELETE CASCADE
);

-- Donations Table
CREATE TABLE IF NOT EXISTS Donations (
    DonationID INTEGER NOT NULL CONSTRAINT PK_Donations PRIMARY KEY AUTOINCREMENT,
    DonorName TEXT NOT NULL,
    Amount DECIMAL(18,2) NOT NULL,
    Destination TEXT DEFAULT 'المدرسة',
    DonationDate TEXT NOT NULL,
    DonationType TEXT DEFAULT 'نقدي',
    ReceiptNumber TEXT DEFAULT '',
    Phone TEXT DEFAULT '',
    Notes TEXT NULL,
    CreatedDate TEXT NOT NULL
);

-- Expenses Table
CREATE TABLE IF NOT EXISTS Expenses (
    ExpenseID INTEGER NOT NULL CONSTRAINT PK_Expenses PRIMARY KEY AUTOINCREMENT,
    Category TEXT NOT NULL DEFAULT 'Other',
    CategoryArabic TEXT DEFAULT 'أخرى',
    Amount DECIMAL(18,2) NOT NULL,
    ExpenseDate TEXT NOT NULL,
    Description TEXT DEFAULT '',
    PaymentMethod TEXT DEFAULT 'نقدي',
    ReceiptNumber TEXT DEFAULT '',
    Notes TEXT NULL,
    CreatedDate TEXT NOT NULL
);

-- Zakat Collections Table
CREATE TABLE IF NOT EXISTS ZakatCollections (
    ZakatID INTEGER NOT NULL CONSTRAINT PK_ZakatCollections PRIMARY KEY AUTOINCREMENT,
    ContributorName TEXT DEFAULT 'مجهول',
    Amount DECIMAL(18,2) NOT NULL,
    CollectionDate TEXT NOT NULL,
    ZakatType TEXT DEFAULT 'زكاة المال',
    ReceiptNumber TEXT DEFAULT '',
    DistributionStatus TEXT DEFAULT 'لم يتم التوزيع',
    Phone TEXT DEFAULT '',
    Notes TEXT NULL,
    CreatedDate TEXT NOT NULL
);

-- Create indexes for performance
CREATE INDEX IF NOT EXISTS IX_TeacherSalaries_TeacherID ON TeacherSalaries (TeacherID);
CREATE INDEX IF NOT EXISTS IX_TeacherSalaries_Month_Year ON TeacherSalaries (Month, Year);
CREATE INDEX IF NOT EXISTS IX_Donations_DonationDate ON Donations (DonationDate);
CREATE INDEX IF NOT EXISTS IX_Expenses_Category ON Expenses (Category);
CREATE INDEX IF NOT EXISTS IX_Expenses_ExpenseDate ON Expenses (ExpenseDate);
CREATE INDEX IF NOT EXISTS IX_ZakatCollections_CollectionDate ON ZakatCollections (CollectionDate);
