-- Migration: Add Payments Table
-- Date: 2025-12-03
-- Description: Add payments and subscription management for students

CREATE TABLE IF NOT EXISTS Payments (
    PaymentID INTEGER PRIMARY KEY AUTOINCREMENT,
    StudentID INTEGER NOT NULL,
    PaymentType VARCHAR(50) NOT NULL DEFAULT 'Monthly',
    PaymentTypeArabic VARCHAR(50) NOT NULL DEFAULT 'شهري',
    Amount DECIMAL(18,2) NOT NULL,
    PaymentDate DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    DueDate DATETIME NOT NULL,
    Status VARCHAR(50) NOT NULL DEFAULT 'Pending',
    StatusArabic VARCHAR(50) NOT NULL DEFAULT 'بانتظار الدفع',
    PaymentMethod VARCHAR(100) DEFAULT '',
    PaymentMethodArabic VARCHAR(100) DEFAULT '',
    ReceiptNumber VARCHAR(200) DEFAULT '',
    Notes TEXT,
    CreatedDate DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PaidDate DATETIME,
    CreatedBy VARCHAR(100) DEFAULT '',
    FOREIGN KEY (StudentID) REFERENCES Students(StudentID) ON DELETE CASCADE
);

-- Create index for faster queries
CREATE INDEX IF NOT EXISTS IX_Payments_StudentID ON Payments(StudentID);
CREATE INDEX IF NOT EXISTS IX_Payments_Status ON Payments(Status);
CREATE INDEX IF NOT EXISTS IX_Payments_DueDate ON Payments(DueDate);
CREATE INDEX IF NOT EXISTS IX_Payments_PaymentDate ON Payments(PaymentDate);
